/*
 * Decompiled with CFR 0.152.
 */
package com.night.star.shopjei;

import com.night.star.shopjei.utils.FtbQuestUtils;
import dev.ftb.mods.ftbquests.quest.Quest;
import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryCondition;
import net.sixik.sdmshoprework.api.shop.AbstractShopTab;
import net.sixik.sdmshoprework.common.shop.condition.ShopFTBQuestsCondition;
import net.sixik.sdmshoprework.common.shop.type.ShopItemEntryType;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ShopJeiEntry
implements Recipe<RecipeWrapper> {
    static Field questIDField;
    private final String title;
    private final AbstractShopEntry entry;

    public ShopJeiEntry(String title, AbstractShopEntry entry) {
        this.title = title;
        this.entry = entry;
    }

    public boolean matches(RecipeWrapper p_44002_, Level p_44003_) {
        return false;
    }

    public ItemStack assemble(RecipeWrapper p_44001_, RegistryAccess p_267165_) {
        return null;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return null;
    }

    public ResourceLocation m_6423_() {
        return ResourceLocation.fromNamespaceAndPath((String)"shopjei", (String)this.entry.entryUUID.toString());
    }

    public RecipeSerializer<?> m_7707_() {
        return null;
    }

    public RecipeType<?> m_6671_() {
        return null;
    }

    public long getPrice() {
        return this.entry.entryPrice;
    }

    public boolean isSell() {
        return this.entry.isSell;
    }

    public String getTitle() {
        return this.title;
    }

    @Nullable
    public Quest getQuest() {
        if (questIDField == null) {
            return null;
        }
        for (AbstractShopEntryCondition entryCondition : this.entry.getEntryConditions()) {
            if (!(entryCondition instanceof ShopFTBQuestsCondition) || !entryCondition.isLocked()) continue;
            try {
                List<Quest> quests = FtbQuestUtils.getNoLockQuests((List)questIDField.get(entryCondition));
                if (quests.isEmpty()) {
                    return null;
                }
                return quests.get(0);
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        return null;
    }

    public String getQuestTitle() {
        Quest quest = this.getQuest();
        if (quest == null) {
            return "";
        }
        return quest.getTitle().getString();
    }

    public boolean isLock() {
        return this.entry.isLocked();
    }

    public AbstractShopTab getShopTab() {
        return this.entry.getShopTab();
    }

    public ItemStack getItemStack() {
        return ((ShopItemEntryType)this.entry.getEntryType()).itemStack;
    }

    public long getCount() {
        return this.entry.entryCount;
    }

    public AbstractShopEntry getEntry() {
        return this.entry;
    }

    static {
        try {
            questIDField = ShopFTBQuestsCondition.class.getDeclaredField("questID");
            questIDField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            questIDField = null;
        }
    }
}

